﻿$(function () {
	$.post("getBigData.html", {
		period : $("#periodVal").attr("value")
	}, function(data) {
	    $('#container').highcharts({
	        title: {
	            text: 'user register/login in/study/exam/resource/Q&A/certificate statistics'
	        },
	        xAxis: {
	        	categories:data.period
	        },
	        yAxis: {
	            title: {
	                text: 'population'
	            },
	            plotLines: [{
	                value: 0,
	                width: 1,
	                color: '#808080'
	            }]
	        },
	        tooltip: {
	            valueSuffix: '个'
	        },
	        legend: {
	            layout: 'vertical',
	            align: 'right',
	            verticalAlign: 'middle',
	            borderWidth: 0
	        },
	        series: [{
	            name: 'register',
	            data: data.regist
	        }, {
	            name: 'login in',
	            data: data.login
	        }, {
	            name: 'study',
	            data: data.course
	        }, {
	            name: 'exam',
	            data: data.exam
	        }, {
	            name: 'resource',
	            data: data.resource
	        }, {
	            name: 'Q&A',
	            data: data.askanswer
	        }, {
	            name: 'certificate',
	            data: data.certificates
	        }]
	    });
	}, "json");
	
	//课件类型选择
	$("li").click(function(){
		$("#periodVal").val($(this).attr("id"));
		$(this).addClass("selecthover").siblings().removeClass("selecthover");
		$.post("getBigData.html", {
			period : $("#periodVal").attr("value")
		}, function(data) {
		    $('#container').highcharts({
		        title: {
		            text: 'user register/login in/study/exam statistics'
		        },
		        xAxis: {
		        	categories:data.period
		        },
		        yAxis: {
		            title: {
		                text: 'population'
		            },
		            plotLines: [{
		                value: 0,
		                width: 1,
		                color: '#808080'
		            }]
		        },
		        tooltip: {
		            valueSuffix: 'people'
		        },
		        legend: {
		            layout: 'vertical',
		            align: 'right',
		            verticalAlign: 'middle',
		            borderWidth: 0
		        },
		        series: [{
		            name: 'register',
		            data: data.regist
		        }, {
		            name: 'login in',
		            data: data.login
		        }, {
		            name: 'study',
		            data: data.course
		        }, {
		            name: 'exam',
		            data: data.exam
		        }, {
		            name: 'resource',
		            data: data.resource
		        }, {
		            name: 'Q&A',
		            data: data.askanswer
		        }, {
		            name: 'certificate',
		            data: data.certificates
		        }]
		    });
		}, "json");
	});
});